/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.orb.GiopInputStream;
import com.visigenic.vbroker.orb.GiopOutputStream;
import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.orb.TypeCode;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class TypeCodeImpl
extends TypeCode
implements OrbObject {
    private ORB _orb;
    private int _kind;
    private String _id;
    private String _name;
    private int _count;
    private String[] _memberNames;
    private org.omg.CORBA.TypeCode[] _memberTypes;
    private Any[] _memberLabels;
    private int _default_index;
    private org.omg.CORBA.TypeCode _contentType;
    private int _recursiveScope;
    private Vector _incompleteTypes;
    private static String[] _tkNames = new String[]{"null", "void", "short", "long", "unsigned short", "unsigned long", "float", "double", "boolean", "char", "octet", "any", "TypeCode", "Principal", "Object", "struct", "union", "enum", "string", "sequence", "array", "alias", "except", "long long", "unsigned long long", "long double", "wchar", "wstring"};

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
    }

    private boolean isIncomplete() {
        return this._incompleteTypes != null && this._incompleteTypes.size() > 0;
    }

    private void addIncompleteTypeCode(Object object) {
        if (this._incompleteTypes == null) {
            this._incompleteTypes = new Vector();
        }
        this._incompleteTypes.addElement(object);
    }

    public TypeCode init_primitive(TCKind tCKind) {
        switch (tCKind.value()) {
            default: {
                throw new BAD_PARAM();
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
        }
        this._kind = tCKind.value();
        return this;
    }

    public TypeCode init_struct(String string, String string2, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_struct, string, string2, null, structMemberArray);
    }

    public TypeCode init_estruct(String string, String string2, org.omg.CORBA.TypeCode typeCode, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_estruct, string, string2, typeCode, structMemberArray);
    }

    public TypeCode init_except(String string, String string2, StructMember[] structMemberArray) {
        return this.init_shared(TCKind.tk_except, string, string2, null, structMemberArray);
    }

    public TypeCode init_recursive_sequence(int n, int n2) {
        this._kind = 19;
        this._count = n;
        this._recursiveScope = n2;
        this.addIncompleteTypeCode(this);
        return this;
    }

    private void fix_recursive_tc(TypeCodeImpl typeCodeImpl, int n, org.omg.CORBA.TypeCode typeCode) {
        if (!typeCodeImpl.isIncomplete()) {
            return;
        }
        if (typeCodeImpl._kind == 19) {
            if (typeCodeImpl._recursiveScope == n) {
                typeCodeImpl._contentType = typeCode;
                typeCodeImpl._incompleteTypes = null;
            }
            return;
        }
        Vector<TypeCodeImpl> vector = null;
        Enumeration enumeration = typeCodeImpl._incompleteTypes.elements();
        while (enumeration.hasMoreElements()) {
            TypeCodeImpl typeCodeImpl2 = (TypeCodeImpl)enumeration.nextElement();
            this.fix_recursive_tc(typeCodeImpl2, n + 1, typeCode);
            if (!typeCodeImpl2.isIncomplete()) continue;
            if (vector == null) {
                vector = new Vector<TypeCodeImpl>();
            }
            vector.addElement(typeCodeImpl2);
        }
        this._incompleteTypes = vector;
    }

    private TypeCode init_shared(TCKind tCKind, String string, String string2, org.omg.CORBA.TypeCode typeCode, StructMember[] structMemberArray) {
        this._kind = tCKind.value();
        this._id = string;
        this._name = string2;
        this._contentType = typeCode;
        this._count = structMemberArray.length;
        this._memberNames = new String[this._count];
        this._memberTypes = new TypeCode[this._count];
        int n = 0;
        while (n < this._count) {
            this._memberNames[n] = structMemberArray[n].name;
            this._memberTypes[n] = structMemberArray[n].type;
            if (this._memberTypes[n] instanceof TypeCodeImpl) {
                TypeCodeImpl typeCodeImpl = (TypeCodeImpl)this._memberTypes[n];
                this.fix_recursive_tc(typeCodeImpl, 1, this);
                if (typeCodeImpl.isIncomplete()) {
                    this.addIncompleteTypeCode(structMemberArray[n].type);
                }
            }
            ++n;
        }
        return this;
    }

    public TypeCode init_union(String string, String string2, org.omg.CORBA.TypeCode typeCode, UnionMember[] unionMemberArray) {
        this._kind = 16;
        this._id = string;
        this._name = string2;
        this._contentType = typeCode;
        this._default_index = -1;
        this._count = unionMemberArray.length;
        this._memberNames = new String[this._count];
        this._memberTypes = new TypeCode[this._count];
        this._memberLabels = new Any[this._count];
        int n = 0;
        while (n < this._count) {
            if (unionMemberArray[n].label.type().kind() == TCKind.tk_octet) {
                this._default_index = n;
            }
            this._memberLabels[n] = unionMemberArray[n].label;
            this._memberNames[n] = unionMemberArray[n].name;
            this._memberTypes[n] = unionMemberArray[n].type;
            if (this._memberTypes[n] instanceof TypeCodeImpl) {
                TypeCodeImpl typeCodeImpl = (TypeCodeImpl)this._memberTypes[n];
                this.fix_recursive_tc(typeCodeImpl, 1, this);
                if (typeCodeImpl.isIncomplete()) {
                    this.addIncompleteTypeCode(unionMemberArray[n].type);
                }
            }
            ++n;
        }
        return this;
    }

    public TypeCode init_enum(String string, String string2, String[] stringArray) {
        this._kind = 17;
        this._id = string;
        this._name = string2;
        this._count = stringArray.length;
        this._memberNames = new String[this._count];
        int n = 0;
        while (n < this._count) {
            this._memberNames[n] = stringArray[n];
            ++n;
        }
        return this;
    }

    public TypeCode init_alias(String string, String string2, org.omg.CORBA.TypeCode typeCode) {
        this._kind = 21;
        this._id = string;
        this._name = string2;
        this._contentType = typeCode;
        return this;
    }

    public TypeCode init_interface(String string, String string2) {
        this._kind = 14;
        this._id = string;
        this._name = string2;
        return this;
    }

    public TypeCode init_string(int n) {
        this._kind = 18;
        this._count = n;
        return this;
    }

    public TypeCode init_wstring(int n) {
        this._kind = 27;
        this._count = n;
        return this;
    }

    public TypeCode init_sequence(org.omg.CORBA.TypeCode typeCode, int n) {
        this._kind = 19;
        this._contentType = typeCode;
        this._count = n;
        return this;
    }

    public TypeCode init_array(org.omg.CORBA.TypeCode typeCode, int n) {
        this._kind = 20;
        this._contentType = typeCode;
        this._count = n;
        return this;
    }

    private boolean requiresEncapsulation(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public TypeCode read(InputStream inputStream, boolean bl) {
        GiopInputStream giopInputStream = (GiopInputStream)inputStream;
        this._kind = giopInputStream.read_long();
        if (!bl && this.requiresEncapsulation(this._kind)) {
            giopInputStream.startEncapsulation();
        }
        switch (this._kind) {
            case 14: {
                this.init_interface(giopInputStream.read_string(), giopInputStream.read_string());
                break;
            }
            case 15: 
            case 22: 
            case 32: {
                this._id = giopInputStream.read_string();
                this._name = giopInputStream.read_string();
                this._contentType = null;
                if (this._kind == 32) {
                    this._contentType = giopInputStream.read_TypeCode();
                }
                this._count = giopInputStream.read_long();
                this._memberNames = new String[this._count];
                this._memberTypes = new TypeCode[this._count];
                int n = 0;
                while (n < this._count) {
                    this._memberNames[n] = giopInputStream.read_string();
                    this._memberTypes[n] = giopInputStream.read_TypeCode();
                    ++n;
                }
                break;
            }
            case 16: {
                this._id = giopInputStream.read_string();
                this._name = giopInputStream.read_string();
                this._contentType = giopInputStream.read_TypeCode();
                this._default_index = giopInputStream.read_long();
                this._count = giopInputStream.read_long();
                this._memberNames = new String[this._count];
                this._memberTypes = new TypeCode[this._count];
                this._memberLabels = new Any[this._count];
                int n = 0;
                while (n < this._count) {
                    this._memberLabels[n] = this._orb.create_any();
                    if (n == this._default_index) {
                        this._memberLabels[n].insert_octet(giopInputStream.read_octet());
                    } else {
                        this._memberLabels[n].read_value(giopInputStream, this._contentType);
                    }
                    this._memberNames[n] = giopInputStream.read_string();
                    this._memberTypes[n] = giopInputStream.read_TypeCode();
                    ++n;
                }
                break;
            }
            case 17: {
                this._id = giopInputStream.read_string();
                this._name = giopInputStream.read_string();
                this._count = giopInputStream.read_long();
                this._memberNames = new String[this._count];
                int n = 0;
                while (n < this._count) {
                    this._memberNames[n] = giopInputStream.read_string();
                    ++n;
                }
                break;
            }
            case 18: {
                this.init_string(giopInputStream.read_long());
                break;
            }
            case 27: {
                this.init_wstring(giopInputStream.read_long());
                break;
            }
            case 19: 
            case 20: {
                this._contentType = giopInputStream.read_TypeCode();
                this._count = giopInputStream.read_long();
                break;
            }
            case 21: {
                this.init_alias(giopInputStream.read_string(), giopInputStream.read_string(), giopInputStream.read_TypeCode());
                break;
            }
            default: {
                throw new MARSHAL("Invalid TypeCode kind: " + this._kind);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
        }
        if (!bl && this.requiresEncapsulation(this._kind)) {
            giopInputStream.endEncapsulation();
        }
        return this;
    }

    public void write(OutputStream outputStream, boolean bl) {
        GiopOutputStream giopOutputStream = (GiopOutputStream)outputStream;
        giopOutputStream.write_long(this._kind);
        if (!bl && this.requiresEncapsulation(this._kind)) {
            giopOutputStream.startEncapsulation();
        }
        switch (this._kind) {
            case 14: {
                giopOutputStream.write_string(this._id);
                giopOutputStream.write_string(this._name);
                break;
            }
            case 15: 
            case 22: 
            case 32: {
                giopOutputStream.write_string(this._id);
                giopOutputStream.write_string(this._name);
                if (this._kind == 32) {
                    giopOutputStream.write_TypeCode(this._contentType);
                }
                giopOutputStream.write_long(this._count);
                int n = 0;
                while (n < this._count) {
                    giopOutputStream.write_string(this._memberNames[n]);
                    giopOutputStream.write_TypeCode(this._memberTypes[n]);
                    ++n;
                }
                break;
            }
            case 16: {
                giopOutputStream.write_string(this._id);
                giopOutputStream.write_string(this._name);
                giopOutputStream.write_TypeCode(this._contentType);
                giopOutputStream.write_long(this._default_index);
                giopOutputStream.write_long(this._count);
                int n = 0;
                while (n < this._count) {
                    this._memberLabels[n].write_value(giopOutputStream);
                    giopOutputStream.write_string(this._memberNames[n]);
                    giopOutputStream.write_TypeCode(this._memberTypes[n]);
                    ++n;
                }
                break;
            }
            case 17: {
                giopOutputStream.write_string(this._id);
                giopOutputStream.write_string(this._name);
                giopOutputStream.write_long(this._count);
                int n = 0;
                while (n < this._count) {
                    giopOutputStream.write_string(this._memberNames[n]);
                    ++n;
                }
                break;
            }
            case 18: 
            case 27: {
                giopOutputStream.write_long(this._count);
                break;
            }
            case 19: 
            case 20: {
                giopOutputStream.write_TypeCode(this._contentType);
                giopOutputStream.write_long(this._count);
                break;
            }
            case 21: {
                giopOutputStream.write_string(this._id);
                giopOutputStream.write_string(this._name);
                giopOutputStream.write_TypeCode(this._contentType);
                break;
            }
        }
        if (!bl && this.requiresEncapsulation(this._kind)) {
            giopOutputStream.endEncapsulation();
        }
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object == null || !(object instanceof org.omg.CORBA.TypeCode)) {
            return false;
        }
        try {
            return this.equal((org.omg.CORBA.TypeCode)object);
        }
        catch (SystemException systemException) {
            return false;
        }
    }

    public boolean equal(org.omg.CORBA.TypeCode typeCode) {
        return TypeCodeImpl.equal(this, typeCode, new Hashtable(), new Hashtable());
    }

    private static boolean equal(org.omg.CORBA.TypeCode typeCode, org.omg.CORBA.TypeCode typeCode2, Dictionary dictionary, Dictionary dictionary2) {
        if (typeCode == typeCode2) {
            return true;
        }
        if (typeCode == null || typeCode2 == null) {
            return false;
        }
        try {
            if (typeCode.kind() == TCKind.tk_alias) {
                return typeCode.content_type().equal(typeCode2);
            }
            if (typeCode2.kind() == TCKind.tk_alias) {
                return typeCode.equal(typeCode2.content_type());
            }
        }
        catch (BadKind badKind) {
            throw new INTERNAL(badKind.toString());
        }
        if (typeCode.kind() != typeCode2.kind()) {
            return false;
        }
        switch (typeCode.kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        try {
            if (!typeCode.name().equals(typeCode2.name())) {
                return false;
            }
        }
        catch (BadKind badKind) {}
        if (!TypeCodeImpl.check_basic_type(typeCode)) {
            Integer n = (Integer)dictionary.get(typeCode);
            Integer n2 = (Integer)dictionary2.get(typeCode2);
            if (n != null && n2 != null) {
                return n.intValue() == n2.intValue();
            }
            if (n != null || n2 != null) {
                return false;
            }
            Integer n3 = new Integer(dictionary.size() + 1);
            dictionary.put(typeCode, n3);
            dictionary2.put(typeCode2, n3);
        }
        try {
            int n = typeCode.member_count();
            if (n != typeCode2.member_count()) {
                return false;
            }
            int n4 = 0;
            while (n4 < n) {
                if (!typeCode.member_name(n4).equals(typeCode2.member_name(n4))) {
                    return false;
                }
                ++n4;
            }
            int n5 = 0;
            while (n5 < n) {
                if (!TypeCodeImpl.equal(typeCode.member_type(n5), typeCode2.member_type(n5), dictionary, dictionary2)) {
                    return false;
                }
                ++n5;
            }
            int n6 = 0;
            while (n6 < n) {
                if (!typeCode.member_label(n6).equal(typeCode2.member_label(n6))) {
                    return false;
                }
                ++n6;
            }
            if (typeCode.default_index() != typeCode2.default_index()) {
                return false;
            }
        }
        catch (BadKind badKind) {
        }
        catch (Bounds bounds) {}
        try {
            if (typeCode.length() != typeCode2.length()) {
                return false;
            }
            if (!TypeCodeImpl.equal(typeCode.content_type(), typeCode2.content_type(), dictionary, dictionary2)) {
                return false;
            }
        }
        catch (BadKind badKind) {}
        return true;
    }

    public TCKind kind() {
        return TCKind.from_int(this._kind);
    }

    public String id() throws BadKind {
        switch (this._kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 32: {
                return this._id;
            }
        }
        throw new BadKind();
    }

    public String name() throws BadKind {
        switch (this._kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 32: {
                return this._name;
            }
        }
        throw new BadKind();
    }

    public int member_count() throws BadKind {
        switch (this._kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 32: {
                return this._count;
            }
        }
        throw new BadKind();
    }

    public String member_name(int n) throws BadKind, Bounds {
        try {
            switch (this._kind) {
                case 15: 
                case 16: 
                case 17: 
                case 22: 
                case 32: {
                    return this._memberNames[n];
                }
            }
            throw new BadKind();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.TypeCode member_type(int n) throws BadKind, Bounds {
        try {
            switch (this._kind) {
                case 15: 
                case 16: 
                case 22: 
                case 32: {
                    return this._memberTypes[n];
                }
            }
            throw new BadKind();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.TypeCode base_type() throws BadKind {
        if (this._kind != 32) {
            throw new BadKind();
        }
        return this._contentType;
    }

    public Any member_label(int n) throws BadKind, Bounds {
        try {
            if (this._kind != 16) {
                throw new BadKind();
            }
            return this._memberLabels[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new Bounds();
        }
    }

    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this._kind != 16) {
            throw new BadKind();
        }
        return this._contentType;
    }

    public int default_index() throws BadKind {
        if (this._kind != 16) {
            throw new BadKind();
        }
        return this._default_index;
    }

    public int length() throws BadKind {
        switch (this._kind) {
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this._count;
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        switch (this._kind) {
            case 19: 
            case 20: 
            case 21: {
                return this._contentType;
            }
        }
        throw new BadKind();
    }

    public String typeCodeName() {
        if (this._kind >= 0 && this._kind <= 27) {
            return _tkNames[this._kind];
        }
        if (this._kind == 32) {
            return "estruct";
        }
        return "<invalid>";
    }

    public String toString() {
        try {
            switch (this._kind) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 21: 
                case 22: 
                case 32: {
                    return this.name();
                }
                case 18: 
                case 27: {
                    if (this.length() == 0) {
                        return _tkNames[this._kind];
                    }
                    return String.valueOf(_tkNames[this._kind]) + "<" + this.length() + ">";
                }
                case 19: {
                    if (this.length() == 0) {
                        return "sequence<" + this.content_type() + ">";
                    }
                    return "sequence<" + this.content_type() + "," + this.length() + ">";
                }
                case 20: {
                    return String.valueOf(this.content_type()) + "[" + this.length() + "]";
                }
            }
            return this.typeCodeName();
        }
        catch (UserException userException) {
            return "org.omg.CORBA.TypeCode[<<<" + userException + ">>>]";
        }
    }

    static boolean check_basic_type(org.omg.CORBA.TypeCode typeCode) {
        switch (typeCode.kind().value()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 18: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                return true;
            }
        }
        return false;
    }
}

